function T = dynamic_g1_tt(T, y, x, params, steady_state, it_)
% function T = dynamic_g1_tt(T, y, x, params, steady_state, it_)
%
% File created by Dynare Preprocessor from .mod file
%
% Inputs:
%   T             [#temp variables by 1]     double  vector of temporary terms to be filled by function
%   y             [#dynamic variables by 1]  double  vector of endogenous variables in the order stored
%                                                    in M_.lead_lag_incidence; see the Manual
%   x             [nperiods by M_.exo_nbr]   double  matrix of exogenous variables (in declaration order)
%                                                    for all simulation periods
%   steady_state  [M_.endo_nbr by 1]         double  vector of steady state values
%   params        [M_.param_nbr by 1]        double  vector of parameter values in declaration order
%   it_           scalar                     double  time period for exogenous variables for which
%                                                    to evaluate the model
%
% Output:
%   T           [#temp variables by 1]       double  vector of temporary terms
%

assert(length(T) >= 46);

T = World_Economy_Competitive.dynamic_resid_tt(T, y, x, params, steady_state, it_);

T(23) = (-(exp(y(6))*exp((-y(43)))*exp(y(10))));
T(24) = exp(y(51))*exp((-y(58)))*exp(y(27))+y(54)*(-(exp((-y(58)))*exp(y(27))));
T(25) = (-(T(15)*(T(24)-params(6)*params(5)*exp(params(5)*(y(27)-y(58))))));
T(26) = exp(y(32))*getPowerDeriv(exp(y(32)),T(1),1);
T(27) = getPowerDeriv(T(7),params(2)/(params(2)-1),1);
T(28) = exp(y(32))*getPowerDeriv(exp(y(32)),T(9),1);
T(29) = exp(y(35))*getPowerDeriv(exp(y(35)),1/params(2),1);
T(30) = exp(y(13))*getPowerDeriv(exp(y(13)),params(3),1);
T(31) = getPowerDeriv(T(5),T(1),1);
T(32) = getPowerDeriv(T(5),T(9),1);
T(33) = exp(y(13))*getPowerDeriv(exp(y(13)),params(3)-1,1);
T(34) = exp(y(14))*getPowerDeriv(exp(y(14)),1+params(8),1);
T(35) = (-(params(9)*T(34)/(1+params(8))));
T(36) = getPowerDeriv(T(18),(-params(14)),1);
T(37) = exp(y(37))*getPowerDeriv(exp(y(37)),1-params(3),1);
T(38) = T(3)*T(37);
T(39) = exp(y(37))*getPowerDeriv(exp(y(37)),(-params(3)),1);
T(40) = exp(y(37))*getPowerDeriv(exp(y(37)),1+params(8),1);
T(41) = (-(params(9)*T(40)/(1+params(8))));
T(42) = getPowerDeriv(T(16),(-params(14)),1);
T(43) = params(1)*T(41)*T(42);
T(44) = exp(y(40))*getPowerDeriv(exp(y(40)),1/params(8),1);
T(45) = (-(T(15)*(exp(y(51))*exp(y(27))*(-exp((-y(58))))+y(54)*(-(exp(y(27))*(-exp((-y(58))))))-params(6)*exp(params(5)*(y(27)-y(58)))*(-params(5)))));
T(46) = T(15)*params(6)*params(5)*exp((params(5)-1)*y(27))*(-params(5))*exp(y(58)*(-params(5)))-(exp(y(51))-y(54))*T(15)*(-exp((-y(58))));

end
